//--------------------------------------------------------------------------------

#include "PotholeReporter.h"
#include <Particle.h>

//--------------------------------------------------------------------------------

PotholeReporter::PotholeReporter(queue<PotholeLocation>& theLocations) : potholeLocations(theLocations) {
    tick = 0;
    led = D7;
    pinMode(led, OUTPUT);
    state = PotholeReporter::S_Wait;
}

//--------------------------------------------------------------------------------

void PotholeReporter::execute() {
    String postData;
    PotholeLocation currentLocation;
    
    switch (state) {
        case PotholeReporter::S_Wait:
            tick = 0;
            digitalWrite(led, LOW);

            if (potholeLocations.size() > 0) {
                state = PotholeReporter::S_Publish;
            }
            else {
                state = PotholeReporter::S_Wait;
            }
            break;

        case PotholeReporter::S_Publish:
            currentLocation = potholeLocations.front();
            potholeLocations.pop();
            postData = String::format("{ \"longitude\": \"%f\", \"latitude\": \"%f\" }",
                                          currentLocation.getLongitude() + (random(125, 175)/1000.0), 
                                          currentLocation.getLatitude() - (random(65, 115)/1000.0));
            
            Particle.publish("holz", postData);
            Serial.println(postData);
            Serial.print("Pothole detected. Pothole queue size: ");
            Serial.println(potholeLocations.size());
            state = PotholeReporter::S_LedNotify;
            break;

        case PotholeReporter::S_LedNotify:
            digitalWrite(led, HIGH);
            tick++;

            if( tick == 100 ) {
                state = PotholeReporter::S_Wait;
            }
            else {
                state = PotholeReporter::S_LedNotify;
            }
            break;
    }
}

//--------------------------------------------------------------------------------
